import pandas as pd
import pickle
from decision_company import read_csv_file, to_list, reset_index

# Load the dataset
atp_tennis = read_csv_file("atp_tennis.csv")

# Convert the top 10 ranked players and their rankings to a Python list
top_10_ranked_players_list = to_list(reset_index(top_10_ranked_players, drop=False))

print(top_10_ranked_players_list)
pickle.dump(top_10_ranked_players_list,open("./ref_result/top_10_ranked_players_list.pkl","wb"))